package ru.yandex.chemodan.app.psbilling.core.promos;

import java.util.Comparator;
import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoApplicationArea;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoApplicationType;
import ru.yandex.chemodan.util.date.DateTimeUtils;

public interface NewPromoTemplate<Usage, Entity> {
    UUID getId();

    boolean isExpired();

    Option<UUID> getPromoNameTankerKey();

    boolean isActive();

    Option<Instant> getToDate();

    String getCode();

    SetF<UUID> getProductLineIds();

    PromoApplicationType getApplicationType();

    PromoApplicationArea getApplicationArea();

    boolean canBeUsed(Option<Usage> usage);

    default boolean canBeUsed(Usage usage) {
        return canBeUsed(Option.of(usage));
    }

    Option<Instant> canBeUsedUntilDate(Option<Usage> usage);

    default Option<Instant> canBeUsedUntilDate(Usage usage) {
        return canBeUsedUntilDate(Option.of(usage));
    }

    void markUsed(Usage usage);

    Option<Entity> activatePromo(Usage usage, boolean force, Function0<Entity> afterCallback);

    boolean isAvailableFor(Usage usage, boolean force);

    static <Usage, Entity> Comparator<NewPromoTemplate<Usage, Entity>> byMultipleTimeThenByUntilDate(Option<Usage> usage) {
        return NewPromoTemplate.<Usage, Entity>byMultipleTimeType()
                .thenComparing(NewPromoTemplate.byUntilDate(usage));
    }

    static <Usage, Entity> Comparator<NewPromoTemplate<Usage, Entity>> byMultipleTimeType() {
        return Comparator.comparing(p -> p.getApplicationType() == PromoApplicationType.MULTIPLE_TIME ? 0 : 1);
    }

    static <Usage, Entity> Comparator<NewPromoTemplate<Usage, Entity>> byUntilDate(Option<Usage> usage) {
        return Comparator.comparing(p -> p.canBeUsedUntilDate(usage).orElse(DateTimeUtils.MAX_INSTANT));
    }
}
