package ru.yandex.chemodan.app.psbilling.core.promos;

import java.util.Comparator;
import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoApplicationArea;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoApplicationType;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.util.date.DateTimeUtils;
import ru.yandex.inside.passport.PassportUid;

//Перейти на NewPromoTemplate
@Deprecated
public interface PromoTemplate {
    UUID getId();

    boolean isExpired();

    boolean isActive();

    Option<Instant> getToDate();

    Option<Instant> canBeUsedUntilDate(Option<PassportUid> uid);

    default boolean canBeUsedForUid(PassportUid uid) {
        return canBeUsedForUid(Option.of(uid));
    }

    boolean canBeUsedForUid(Option<PassportUid> uid);

    boolean canBeUsedForUidInFuture(Option<PassportUid> uid);

    boolean canActivateForUid(PassportUid uid, boolean activateIfUsed);

    String getCode();

    Option<String> getTitle(String language);

    SetF<UUID> getProductLineIds();

    PromoApplicationType getApplicationType();

    PromoApplicationArea getApplicationArea();

    boolean activatePromoForUser(PassportUid uid, boolean activateIfUsed, boolean sendEmail,
                                 Function<MailContext.MailContextBuilder, MailContext.MailContextBuilder> mailContextCustomizer);

    default boolean activatePromoForUser(PassportUid uid, boolean activateIfUsed, boolean sendEmail) {
        return activatePromoForUser(uid, activateIfUsed, sendEmail, Function.identityF());
    }


    void markUsedForUser(PassportUid uid);

    static Comparator<PromoTemplate> topMultipleTimeThenByUntilDate(Option<PassportUid> uidO) {
        return Comparator
                .<PromoTemplate, Integer>comparing(p -> p.getApplicationType() == PromoApplicationType.MULTIPLE_TIME ? 0 : 1)
                .thenComparing(p -> p.canBeUsedUntilDate(uidO).orElse(DateTimeUtils.MAX_INSTANT));
    }
}
