package ru.yandex.chemodan.app.psbilling.core.promos.groups;

import java.util.UUID;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.group.GroupPromoDao;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoTemplateEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.group.GroupPromoEntity;
import ru.yandex.chemodan.app.psbilling.core.promos.NewAbstractPromoTemplate;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;


public abstract class AbstractGroupPromoTemplate extends NewAbstractPromoTemplate<Group, GroupPromoEntity> {

    protected final GroupPromoDao groupPromoDao;

    public AbstractGroupPromoTemplate(
            PromoTemplateEntity promoTemplate,
            UserTimezoneHelper userTimezoneHelper,
            Function0<SetF<UUID>> provideProductLine,
            GroupPromoDao groupPromoDao,
            Option<Tuple2<Group, GroupPromoEntity>> warmingCache
    ) {
        super(promoTemplate, userTimezoneHelper, provideProductLine);
        this.groupPromoDao = groupPromoDao;

        warmingCache.ifPresent(promoEntityCache::put);
    }

    public AbstractGroupPromoTemplate(
            PromoTemplateEntity promoTemplate,
            UserTimezoneHelper userTimezoneHelper,
            Function0<SetF<UUID>> provideProductLine,
            GroupPromoDao groupPromoDao
    ) {
        this(promoTemplate, userTimezoneHelper, provideProductLine, groupPromoDao, Option.empty());
    }

    @Override
    public Option<GroupPromoEntity> lookupPromoEntity(Group group) {
        return groupPromoDao.findByGroupIdAndPromoTemplateId(group.getId(), getId());
    }
}
