package ru.yandex.chemodan.app.psbilling.core.promos.tasks;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.tasks.BaseTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.BaseTaskParams;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskExecutor;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPoliciesHolder;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class ActivatePromoTask extends BaseTask<ActivatePromoTask.Parameters> {

    public ActivatePromoTask(ActivatePromoTask.Parameters parameters) {
        super(parameters);
    }

    public ActivatePromoTask(TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
                             ListF<TaskExecutor<?>> taskExecutors) {
        super(taskPreExecutionPoliciesHolder, taskExecutors, ActivatePromoTask.Parameters.class);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters implements BaseTaskParams {
        private final String promoCode;
        private final PassportUid userId;
        private final boolean activateIfUsed;
        private final boolean sendEmail;
        private final String preExecutionPolicy;
        private final String executorKey;
        @Builder.Default
        private Option<PaymentErrorContext> paymentErrorContext = Option.empty();
        @Builder.Default
        private Option<Duration> cooldown = Option.empty();
    }
}

