package ru.yandex.chemodan.app.psbilling.core.synchronization.engine;

import java.util.UUID;

import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public abstract class AbstractTablesSynchronizer<P extends SynchronizableRecord, C extends SynchronizableRecord,
        B extends InsertingData<C>>
        extends BaseTablesSynchronizer<P> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTablesSynchronizer.class);

    protected final ChildSynchronizableRecordDao<C, B> childDao;

    public AbstractTablesSynchronizer(ChildSynchronizableRecordDao<C, B> childDao,
                                      ParentSynchronizableRecordDao<P> parentDao,
                                      TransactionTemplate transactionTemplate, BazingaTaskManager bazingaTaskManager) {
        super(parentDao, transactionTemplate, bazingaTaskManager);
        this.childDao = childDao;
    }

    public void updateDataInChildTable(UUID parentId,
                                       SynchronizerConfig<P, C, B> synchronizerConfig) {
        if (!synchronizerConfig.isEnabled()) {
            logger.info("update child records of parent {} is disabled", parentId);
            return;
        }
        transactionTemplate.execute(st -> {
            P parentRecord = parentDao.lockRecord(parentId);
            logger.info("Start synchronizing {}", parentRecord);

            UpdateResult<C,B> updateResult = updateDataInChildTableCore(parentRecord, childDao,
                    synchronizerConfig.getActiveActualChildrenProducer(),
                    synchronizerConfig.getSynchronizationKeyProvider());

            if (updateResult.getUpdated() || parentRecord.getStatus() == SynchronizationStatus.INIT) {
                parentDao.updateStatusToSyncing(parentRecord.getId());
            }

            if (updateResult.getToInsert().isNotEmpty()) {
                insertCallback(parentRecord, updateResult.getToInsert());
            }

            parentDao.unlockRecord(parentRecord);
            return null;
        });

        scheduleChildrenSynchronization(parentId);
    }

    protected void insertCallback(P parentRecord, ListF<B> insertedData) {
    }
}
