package ru.yandex.chemodan.app.psbilling.core.synchronization.engine;

import java.util.UUID;

import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public abstract class AbstractTablesSynchronizer2<P extends SynchronizableRecord,
        C1 extends SynchronizableRecord, B1 extends InsertingData<C1>,
        C2 extends SynchronizableRecord, B2 extends InsertingData<C2>>
        extends BaseTablesSynchronizer<P> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTablesSynchronizer2.class);

    protected final ChildSynchronizableRecordDao<C1, B1> childDao1;
    protected final ChildSynchronizableRecordDao<C2, B2> childDao2;

    public AbstractTablesSynchronizer2(ParentSynchronizableRecordDao<P> parentDao,
                                       ChildSynchronizableRecordDao<C1, B1> childDao1,
                                       ChildSynchronizableRecordDao<C2, B2> childDao2,
                                       TransactionTemplate transactionTemplate, BazingaTaskManager bazingaTaskManager) {
        super(parentDao, transactionTemplate, bazingaTaskManager);
        this.childDao1 = childDao1;
        this.childDao2 = childDao2;
    }

    public void updateDataInChildTable(UUID parentId,
                                       SynchronizerConfig<P, C1, B1> synchronizerConfig1,
                                       SynchronizerConfig<P, C2, B2> synchronizerConfig2) {
        transactionTemplate.execute(st -> {
            P parentRecord = parentDao.lockRecord(parentId);
            logger.info("Start synchronizing {}", parentRecord);
            UpdateResult<C1, B1> updateResult1;
            UpdateResult<C2, B2> updateResult2;

            if (synchronizerConfig1.isEnabled()) {
                updateResult1 = updateDataInChildTableCore(parentRecord, childDao1,
                        synchronizerConfig1.getActiveActualChildrenProducer(),
                        synchronizerConfig1.getSynchronizationKeyProvider());
            } else {
                updateResult1 = new UpdateResult<>(false, Cf.list());
            }

            if (synchronizerConfig2.isEnabled()) {
                updateResult2 = updateDataInChildTableCore(parentRecord, childDao2,
                        synchronizerConfig2.getActiveActualChildrenProducer(),
                        synchronizerConfig2.getSynchronizationKeyProvider());
            } else {
                updateResult2 = new UpdateResult<>(false, Cf.list());
            }

            boolean updated = updateResult1.getUpdated() || updateResult2.getUpdated();

            if (updated || parentRecord.getStatus() == SynchronizationStatus.INIT) {
                parentDao.updateStatusToSyncing(parentRecord.getId());
            }

            if (updateResult1.getUpdated()) {
                updateCallback1(parentRecord, updateResult1);
            }

            if (updateResult2.getUpdated()) {
                updateCallback2(parentRecord, updateResult2);
            }

            if (updateResult1.getToInsert().isNotEmpty()) {
                insertCallback1(parentRecord, updateResult1.getToInsert());
            }

            if (updateResult2.getToInsert().isNotEmpty()) {
                insertCallback2(parentRecord, updateResult2.getToInsert());
            }

            parentDao.unlockRecord(parentRecord);
            return null;
        });

        scheduleChildrenSynchronization(parentId);
    }

    protected void updateCallback1(P parentRecord, UpdateResult<C1, B1> updateResult) {

    }

    protected void updateCallback2(P parentRecord, UpdateResult<C2, B2> updateResult) {

    }

    protected void insertCallback1(P parentRecord, ListF<B1> insertedData) {
    }

    protected void insertCallback2(P parentRecord, ListF<B2> insertedData) {
    }
}
