package ru.yandex.chemodan.app.psbilling.core.synchronization.engine;

import java.util.UUID;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;

public interface ChildSynchronizableRecordDao<T extends SynchronizableRecord, C extends InsertingData<T>> {
    default ListF<T> findEnabledByParentId(UUID id) {
        return getChildSynchronizableRecordDaoHelper().findEnabledByParentId(id);
    }

    default ListF<T> findInInitByParentId(UUID parentId) {
        return getChildSynchronizableRecordDaoHelper().findInInitByParentId(parentId);
    }


    void batchInsert(ListF<C> toInsert, Target target);

    default void setTargetState(ListF<UUID> ids, Target target) {
        getChildSynchronizableRecordDaoHelper().setTargetState(ids, target);
    }

    ChildSynchronizableRecordJDBCHelper<T> getChildSynchronizableRecordDaoHelper();

}
