package ru.yandex.chemodan.app.psbilling.core.synchronization.engine;

import java.sql.ResultSet;
import java.time.Instant;
import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

@AllArgsConstructor
public class ChildSynchronizableRecordJDBCHelper<T extends SynchronizableRecord> {
    private JdbcTemplate3 jdbcTemplate;
    private String tableName;
    private Option<String> parentField;
    private Function<ResultSet, T> rowParser;

    public ListF<T> findEnabledByParentId(UUID parentId) {
        if (!parentField.isPresent()) {
            throw new UnsupportedOperationException();
        }
        return jdbcTemplate.query("select * from " + tableName + " where target = ? and " + parentField.get() + " = ?",
                (rs, num) -> rowParser.apply(rs), Target.ENABLED.value(), parentId);
    }

    public ListF<T> findInInitByParentId(UUID parentId) {
        if (!parentField.isPresent()) {
            throw new UnsupportedOperationException();
        }

        return jdbcTemplate.query("select * from " + tableName + " where status = ? and " + parentField.get() + " = ?",
                (rs, num) -> rowParser.apply(rs), SynchronizationStatus.INIT.value(), parentId);
    }

    public void setTargetState(ListF<UUID> ids, Target target) {
        if (ids.isEmpty()) {
            return;
        }

        MapF<String, Object> params = Cf.hashMap();
        params.put("new_target", target.value());
        params.put("sync_status", SynchronizationStatus.INIT.value());
        params.put("now", Instant.now());
        params.put("ids", ids);

        jdbcTemplate.update("update " + tableName + " set target = :new_target, status = :sync_status," +
                "status_updated_at = :now, target_updated_at = :now " +
                "where id in ( :ids )", params);
    }
}
