package ru.yandex.chemodan.app.psbilling.core.synchronization.engine;

import java.util.UUID;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;

public interface IParentSynchronizableRecordJdbcHelper<T extends SynchronizableRecord> {
    T lockRecord(UUID id);

    void updateStatusToSyncing(UUID id);

    Option<UUID> analyzeChildrenStatus(UUID lastProcessedId, int limit, boolean propagateSnoozing);

    void unlockRecord(T parentRecord);

    ListF<UUID> findRecordsInInitStatus();

    void setStatusActual(ListF<UUID> ids, Target withTarget);

    int countNotActualUpdatedBefore(Duration triggeredBefore, boolean countSnoozed);

    void resetSyncingStatus(ListF<UUID> ids);
}
