package ru.yandex.chemodan.app.psbilling.core.synchronization.engine;

import java.util.UUID;

import com.google.common.annotations.VisibleForTesting;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;

public interface ParentSynchronizableRecordDao<T extends SynchronizableRecord> {
    default int countNotActualUpdatedBefore(Duration triggeredBefore) {
        return getParentSynchronizableRecordDaoHelper().countNotActualUpdatedBefore(triggeredBefore,false);
    }

    default T lockRecord(UUID id) {
        return getParentSynchronizableRecordDaoHelper().lockRecord(id);
    }

    default void updateStatusToSyncing(UUID id) {
        getParentSynchronizableRecordDaoHelper().updateStatusToSyncing(id);
    }

    default Option<UUID> analyzeChildrenStatus(UUID analyzeGreaterThan, int limit, boolean propagateSnoozing) {
        return getParentSynchronizableRecordDaoHelper()
                .analyzeChildrenStatus(analyzeGreaterThan, limit, propagateSnoozing);
    }

    default void unlockRecord(T parentRecord) {
        getParentSynchronizableRecordDaoHelper().unlockRecord(parentRecord);
    }

    default ListF<UUID> findRecordsInInitStatus() {
        return getParentSynchronizableRecordDaoHelper().findRecordsInInitStatus();
    }

    default void resetSyncingStatus(ListF<UUID> ids) {
        getParentSynchronizableRecordDaoHelper().resetSyncingStatus(ids);
    }

    @VisibleForTesting
    default void setStatusActual(ListF<UUID> ids, Target withTarget) {
        getParentSynchronizableRecordDaoHelper().setStatusActual(ids, withTarget);
    }

    IParentSynchronizableRecordJdbcHelper<T> getParentSynchronizableRecordDaoHelper();
}
