package ru.yandex.chemodan.app.psbilling.core.synchronization.engine;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntityWithIdEqHash;

@Getter
public abstract class SynchronizableRecord extends AbstractEntityWithIdEqHash {
    /**
     * requires column target
     */
    protected Target target;
    /**
     * requires column target_updated_at
     */
    protected Instant targetUpdatedAt;
    /**
     * requires column status
     */
    protected SynchronizationStatus status;
    /**
     * requires column status_updated_at
     */
    protected Instant statusUpdatedAt;
    /**
     * when status == actual && target == enabled
     * requires column actual_enabled_at
     */
    protected Option<Instant> actualEnabledAt;
    /**
     * when status == actual && target == disabled
     * requires column actual_disabled_at
     */
    protected Option<Instant> actualDisabledAt;

    public SynchronizableRecord(UUID id, Instant createdAt,
            Target target, Instant targetUpdatedAt,
            SynchronizationStatus status, Instant statusUpdatedAt, Option<Instant> actualEnabledAt,
            Option<Instant> actualDisabledAt)
    {
        super(id, createdAt);
        this.target = target;
        this.targetUpdatedAt = targetUpdatedAt;
        this.status = status;
        this.statusUpdatedAt = statusUpdatedAt;
        this.actualEnabledAt = actualEnabledAt;
        this.actualDisabledAt = actualDisabledAt;
    }
}
