package ru.yandex.chemodan.app.psbilling.core.synchronization.engine;

import lombok.Getter;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;

@Getter
public class SynchronizerConfig<
        P extends SynchronizableRecord,
        C extends SynchronizableRecord,
        B extends InsertingData<C>> {
    private final boolean enabled;
    private final Function<P, MapF<String, B>> activeActualChildrenProducer;
    private final Function<C, String> synchronizationKeyProvider;

    public SynchronizerConfig(Function<P, MapF<String, B>> activeActualChildrenProducer,
                              Function<C, String> synchronizationKeyProvider) {
        this(true, activeActualChildrenProducer, synchronizationKeyProvider);
    }

    public SynchronizerConfig(boolean enabled,
                              Function<P, MapF<String, B>> activeActualChildrenProducer,
                              Function<C, String> synchronizationKeyProvider) {
        this.enabled = enabled;
        this.activeActualChildrenProducer = activeActualChildrenProducer;
        this.synchronizationKeyProvider = synchronizationKeyProvider;
    }
}
