package ru.yandex.chemodan.app.psbilling.core.synchronization.feature;

import java.util.UUID;

import javax.annotation.Nullable;

import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;

public abstract class FeatureActualizationTask<TOwner, TParams extends FeatureActualizationTask.Parameters<TOwner>>
        extends OnetimeTaskSupport<TParams> {
    private final AbstractFeatureActualizationService<TOwner, TParams> featureActualizationService;

    public FeatureActualizationTask(TParams params) {
        super(params);
        this.featureActualizationService = null;
    }

    public FeatureActualizationTask(AbstractFeatureActualizationService<TOwner, TParams> featureActualizationService,
                                    Class<TParams> parametersClass) {
        super(parametersClass);
        this.featureActualizationService = featureActualizationService;
    }

    @Override
    protected void execute(TParams parameters, ExecutionContext context) {
        featureActualizationService.synchronize(parameters.getOwnerId(), parameters.getFeatureId(),
                timeout());
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.SYNCHRONIZE_FEATURES;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1), 3);
    }

    @Nullable
    @Override
    public abstract Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter();

    @Data
    public abstract static class Parameters<TOwner> {
        public abstract TOwner getOwnerId();

        public abstract UUID getFeatureId();
    }
}
