package ru.yandex.chemodan.app.psbilling.core.synchronization.feature;

import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.jetbrains.annotations.Nullable;

import ru.yandex.chemodan.app.psbilling.core.entities.features.FeatureWithOwner;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservicefeature.GroupFeaturesActualizationService;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class GroupFeatureActualizationTask extends FeatureActualizationTask<UUID,
        GroupFeatureActualizationTask.Parameters> {
    public GroupFeatureActualizationTask(GroupFeaturesActualizationService groupFeaturesActualizationService) {
        super(groupFeaturesActualizationService, Parameters.class);
    }

    public GroupFeatureActualizationTask(FeatureWithOwner<UUID> feature) {
        this(feature.getOwnerId(), feature.getFeatureId());
    }

    public GroupFeatureActualizationTask(UUID groupdId, UUID featureId) {
        super(new Parameters(groupdId, featureId));
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return Parameters.Converter.class;
    }


    @BenderBindAllFields
    @AllArgsConstructor
    @Getter
    public static class Parameters extends FeatureActualizationTask.Parameters<UUID> {
        private final UUID groupId;
        private final UUID featureId;

        @Override
        public UUID getOwnerId() {
            return groupId;
        }

        public static class Converter implements ActiveUniqueIdentifierConverter<Parameters, Parameters> {
            @Override
            public Class<Parameters> getActiveUniqueIdentifierClass() {
                return Parameters.class;
            }

            @Override
            public Parameters convert(Parameters parameters) {
                return parameters;
            }
        }
    }
}
