package ru.yandex.chemodan.app.psbilling.core.synchronization.feature;

import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.jetbrains.annotations.Nullable;

import ru.yandex.chemodan.app.psbilling.core.entities.features.FeatureWithOwner;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservicefeature.UserFeaturesActualizationService;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class UserFeatureActualizationTask extends FeatureActualizationTask<String,
        UserFeatureActualizationTask.Parameters> {
    public UserFeatureActualizationTask(UserFeaturesActualizationService userFeaturesActualizationService) {
        super(userFeaturesActualizationService, Parameters.class);
    }

    public UserFeatureActualizationTask(FeatureWithOwner<String> feature) {
        this(feature.getOwnerId(), feature.getFeatureId());
    }

    public UserFeatureActualizationTask(String ownerId, UUID featureId) {
        super(new Parameters(ownerId, featureId));
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return Parameters.Converter.class;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Getter
    public static class Parameters extends FeatureActualizationTask.Parameters<String> {
        private final String uid;
        private final UUID featureId;

        @Override
        public String getOwnerId() {
            return uid;
        }

        public static class Converter implements ActiveUniqueIdentifierConverter<Parameters, Parameters> {
            @Override
            public Class<Parameters> getActiveUniqueIdentifierClass() {
                return Parameters.class;
            }

            @Override
            public Parameters convert(Parameters parameters) {
                return parameters;
            }
        }
    }
}
