package ru.yandex.chemodan.app.psbilling.core.synchronization.feature.errorprocessors;

import lombok.AllArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpStatusCodeException;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.FeatureState;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts.DeactivationContext;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts.SetAmountContext;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.net.LocalhostUtils;

@AllArgsConstructor
public abstract class AbstractErrorProcessor implements ErrorProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractErrorProcessor.class);
    private final Blackbox2 blackbox2;

    @Override
    public boolean activationErrorMustBeSnoozed(HttpStatusCodeException e) {
        return false;
    }

    @Override
    public boolean skipSetAmountException(FeatureState featureState,
                                          SetAmountContext context, HttpStatusCodeException e) {
        if (context.getUidO().isPresent()) {
            if (featureState.isNeedToDeactivate() && e.getStatusCode() == HttpStatus.NOT_FOUND &&
                    !userExists(context.getUidO().get())) {
                logger.warn("User {} doesn't exist, so we consider set amount error 404 for feature {} as success",
                        context.getUidO().get(), featureState.getFeature().getId());
                return true;
            }
        }

        return false;
    }

    @Override
    public boolean skipDeactivationException(FeatureState featureState, DeactivationContext context,
                                             HttpStatusCodeException e) {
        if (context.getUidO().isPresent()) {
            if (featureState.isNeedToDeactivate() && e.getStatusCode() == HttpStatus.NOT_FOUND &&
                    !userExists(context.getUidO().get())) {
                logger.warn("User {} doesn't exist, so we consider deactivating error 404 for feature {} as success",
                        context.getUidO().get(), featureState.getFeature().getId());
                return true;
            }
        }
        return false;
    }

    private boolean userExists(String uid) {
        BlackboxCorrectResponse response = blackbox2.query().userInfo(LocalhostUtils.localAddress(),
                PassportUid.cons(Long.parseLong(uid)), Cf.<String>list());

        return response.getUid().isPresent();
    }
}
