package ru.yandex.chemodan.app.psbilling.core.synchronization.feature.errorprocessors;

import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpStatusCodeException;

import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.FeatureState;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts.DeactivationContext;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts.SetAmountContext;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

public class MailErrorProcessor extends AbstractErrorProcessor {
    private static final String NAME = "mail";

    public MailErrorProcessor(Blackbox2 blackbox2) {
        super(blackbox2);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean activationErrorMustBeSnoozed(HttpStatusCodeException e) {
        if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
            return true;
        }
        return super.activationErrorMustBeSnoozed(e);
    }

    @Override
    public boolean skipSetAmountException(
            FeatureState featureState,
            SetAmountContext context,
            HttpStatusCodeException e)
    {
        if (featureState.isNeedToDeactivate() && e.getStatusCode() == HttpStatus.NOT_FOUND) {
            return true;
        }

        return super.skipSetAmountException(featureState, context, e);
    }

    @Override
    public boolean skipDeactivationException(
            FeatureState featureState,
            DeactivationContext context,
            HttpStatusCodeException e)
    {
        if (featureState.isNeedToDeactivate() && e.getStatusCode() == HttpStatus.NOT_FOUND) {
            return true;
        }

        return super.skipDeactivationException(featureState, context, e);
    }
}
