package ru.yandex.chemodan.app.psbilling.core.synchronization.feature.errorprocessors;

import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpStatusCodeException;

import ru.yandex.inside.passport.blackbox2.Blackbox2;

public class MpfsSkipNotInitializedErrorProcessor extends MpfsErrorProcessor {
    private static final String USER_NOT_INITIALIZED_ERROR_CODE = "44";
    private static final String NAME = "mpfs_with_skip_not_initialized";

    public MpfsSkipNotInitializedErrorProcessor(Blackbox2 blackbox2) {
        super(blackbox2);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean activationErrorMustBeSnoozed(HttpStatusCodeException e) {
        if (isErrorWithCode(e, HttpStatus.BAD_REQUEST, USER_NOT_INITIALIZED_ERROR_CODE)) {
            return true;
        }

        return super.activationErrorMustBeSnoozed(e);
    }
}
