package ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts;

import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;

@AllArgsConstructor
public class GroupTemplateContextFactory implements TemplateContextFactory<UUID> {
    private GroupDao groupDao;

    public SetAmountContext createSetAmountContext(UUID groupId, BigDecimal amount, Map<String, Object> context) {
        return new SetAmountContext(Option.empty(), getGroupContextId(groupId), amount, context);
    }

    public ActivationContext createActivationContext(UUID groupId, String uniq, BigDecimal amount) {
        return new ActivationContext(Option.empty(), getGroupContextId(groupId), uniq, amount);
    }

    public DeactivationContext createDeactivationContext(UUID groupId, Map<String, Object> context) {
        return new DeactivationContext(Option.empty(), getGroupContextId(groupId), context);
    }

    private Option<String> getGroupContextId(UUID groupId) {
        return Option.of(groupDao.findById(groupId).getExternalId());
    }
}
