package ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts;

import java.math.BigDecimal;
import java.util.Map;

import ru.yandex.bolts.collection.Option;

public class UserTemplateContextFactory implements TemplateContextFactory<String> {
    public SetAmountContext createSetAmountContext(String uid, BigDecimal amount, Map<String, Object> context) {
        return new SetAmountContext(Option.of(uid), Option.empty(), amount, context);
    }

    public ActivationContext createActivationContext(String uid, String uniq, BigDecimal amount) {
        return new ActivationContext(Option.of(uid), Option.empty(), uniq, amount);
    }

    public DeactivationContext createDeactivationContext(String uid, Map<String, Object> context) {
        return new DeactivationContext(Option.of(uid), Option.empty(), context);
    }
}
