package ru.yandex.chemodan.app.psbilling.core.synchronization.groupmember;

import java.util.UUID;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class GroupServiceMemberActualizationTask extends
        OnetimeTaskSupport<GroupServiceMemberActualizationTask.Parameters>
{
    private final GroupServiceMemberActualizationService groupServiceMemberActualizationService;

    public GroupServiceMemberActualizationTask(UUID groupServiceMemberId)
    {
        super(new Parameters(groupServiceMemberId.toString()));
        this.groupServiceMemberActualizationService = null;
    }

    public GroupServiceMemberActualizationTask(
            GroupServiceMemberActualizationService groupServiceMemberActualizationService)
    {
        super(Parameters.class);
        this.groupServiceMemberActualizationService = groupServiceMemberActualizationService;
    }


    @Override
    protected void execute(Parameters parameters, ExecutionContext context) {
        groupServiceMemberActualizationService
                .actualizeGroupServiceMember(UUID.fromString(parameters.groupServiceMemberId));
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.REGULAR;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardSeconds(30);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }


    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1), 3);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return Parameters.Converter.class;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final String groupServiceMemberId;

        public Parameters(UUID groupServiceMemberId) {
            this.groupServiceMemberId = groupServiceMemberId.toString();
        }

        public static class Converter implements ActiveUniqueIdentifierConverter<Parameters, Parameters> {
            @Override
            public Class<Parameters> getActiveUniqueIdentifierClass() {
                return Parameters.class;
            }

            @Override
            public Parameters convert(Parameters parameters) {
                return parameters;
            }
        }
    }


}
