package ru.yandex.chemodan.app.psbilling.core.synchronization.groupmember;

import java.util.UUID;

import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceMemberDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupServiceMember;
import ru.yandex.chemodan.app.psbilling.core.entities.users.UserServiceEntity;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.AbstractTablesSynchronizer;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservice.UserServiceActualizationTask;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.misc.lang.Validate;

public class GroupServiceMemberTableSynchronizer extends
        AbstractTablesSynchronizer<GroupServiceMember, UserServiceEntity, UserServiceDao.InsertData>
{
    private final GroupServiceMemberDao groupServiceMemberDao;

    public GroupServiceMemberTableSynchronizer(UserServiceDao childDao, GroupServiceMemberDao parentDao,
            TransactionTemplate transactionTemplate, BazingaTaskManager bazingaTaskManager)
    {
        super(childDao, parentDao, transactionTemplate, bazingaTaskManager);
        this.groupServiceMemberDao = parentDao;
    }

    @Override
    protected void insertCallback(GroupServiceMember parentRecord, ListF<UserServiceDao.InsertData> insertedData) {
        Validate.sizeIs(1, insertedData);
        UserServiceDao.InsertData userService = insertedData.first();
        groupServiceMemberDao.updateUserServiceId(parentRecord.getId(), userService.getId());
    }

    @Override
    protected void scheduleChildrenSynchronization(UUID parentId) {
        ListF<UserServiceEntity> childrenInInit = childDao.findInInitByParentId(parentId);
        childrenInInit.map(UserServiceEntity::getId).map(UserServiceActualizationTask::new)
                .forEach(bazingaTaskManager::schedule);
    }
}
