package ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice;

import java.util.UUID;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class GroupActualizationTask extends OnetimeTaskSupport<GroupActualizationTask.Parameters> {
    private static final Logger logger = LoggerFactory.getLogger(GroupActualizationTask.class);
    private final GroupServicesActualizationService groupServicesActualizationService;

    public GroupActualizationTask(UUID groupId)
    {
        super(new Parameters(groupId.toString()));
        this.groupServicesActualizationService = null;
    }

    public GroupActualizationTask(GroupServicesActualizationService groupServicesActualizationService)
    {
        super(Parameters.class);
        this.groupServicesActualizationService = groupServicesActualizationService;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws InterruptedException {
        groupServicesActualizationService.actualize(UUID.fromString(parameters.groupId));
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.SYNCHRONIZE_ORGANIZATION;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_FINISHED, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1), 5);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return Parameters.Converter.class;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final String groupId;

        public Parameters(UUID groupId) {
            this.groupId = groupId.toString();
        }

        public static class Converter implements ActiveUniqueIdentifierConverter<Parameters, Parameters> {
            @Override
            public Class<Parameters> getActiveUniqueIdentifierClass() {
                return Parameters.class;
            }

            @Override
            public Parameters convert(Parameters parameters) {
                return parameters;
            }
        }
    }
}
