package ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice;

import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupType;

@AllArgsConstructor
public class GroupServicesActualizationServiceDecorator implements GroupServicesActualizationService {

    FeatureFlags featureFlags;
    GroupServicesActualizationServiceImpl newService;
    GroupServicesActualizationServiceOld oldService;

    @Override
    public void scheduleGroupActualizationTasks() {
        getActualizer().scheduleGroupActualizationTasks();

    }

    @Override
    public void scheduleForceGroupActualization(GroupType groupType, String externalOrganizationId) {
        getActualizer().scheduleForceGroupActualization(groupType, externalOrganizationId);

    }

    @Override
    public void scheduleForceGroupActualization(UUID internalGroupId) {
        getActualizer().scheduleForceGroupActualization(internalGroupId);

    }

    @Override
    public void actualize(UUID internalGroupId) {
        getActualizer().actualize(internalGroupId);

    }

    @Override
    public void updateGroupServicesSyncState() {
        getActualizer().updateGroupServicesSyncState();

    }

    @Override
    public void updateGroupServicesSyncState(int batchSize) {
        getActualizer().updateGroupServicesSyncState(batchSize);

    }

    GroupServicesActualizationService getActualizer() {
        if (featureFlags.getNewGroupSyncEnabled().isEnabled()) {
            return newService;
        }
        return oldService;
    }
}
