package ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.actualizers;

import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductTemplateFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.directory.DirectoryService;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.staff.YandexStaffService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServiceTableSynchronizer;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;

@AllArgsConstructor
public class GroupServiceActualizerFactory {

    private final GroupProductDao groupProductDao;
    private final ProductFeatureDao productFeatureDao;
    private final ProductTemplateFeatureDao productTemplateFeatureDao;
    private final DirectoryService directoryService;
    private final GroupServiceTableSynchronizer tablesSynchronizer;
    private final TaskScheduler taskScheduler;
    private final GroupDao groupDao;
    private final GroupServiceDao groupServiceDao;
    private final YandexStaffService yandexStaffService;
    private final FeatureFlags featureFlags;

    public GroupServiceActualizer getActualizer(UUID groupId) {
        return getActualizer(groupDao.findById(groupId));
    }

    public GroupServiceActualizer getActualizer(Group group) {
        switch (group.getType()) {
            case ORGANIZATION:
                return new OrganizationGroupServicesActualizer(groupProductDao, productFeatureDao,
                        productTemplateFeatureDao, directoryService, tablesSynchronizer, taskScheduler, groupDao,
                        groupServiceDao, featureFlags, group);
            case STAFF:
                return new StaffGroupServicesActualizer(groupProductDao, productFeatureDao, productTemplateFeatureDao,
                        directoryService, tablesSynchronizer, taskScheduler, groupDao, groupServiceDao, featureFlags,
                        yandexStaffService, group);
            case ORGANIZATION_USER:
                return new OrganizationUserGroupServicesActualizer(taskScheduler, groupDao, group);
            case FAMILY:
                throw new NotImplementedException();
            default:
                throw new UnsupportedOperationException("Unexpected value: " + group.getType());
        }
    }
}
