package ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.actualizers;

import org.joda.time.Instant;

import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupActualizationTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;

public class OrganizationUserGroupServicesActualizer implements GroupServiceActualizer {

    private final GroupDao groupDao;
    private final TaskScheduler taskScheduler;
    private final Group group;

    OrganizationUserGroupServicesActualizer(TaskScheduler taskScheduler, GroupDao groupDao, Group group) {
        this.groupDao = groupDao;
        this.taskScheduler = taskScheduler;
        this.group = group;
    }

    @Override
    public void scheduleActualization() {
        groupDao.updateGroupNextSyncTime(group.getId(), Instant.now());
        taskScheduler.schedule(new GroupActualizationTask(group.getParentGroupId().get()));
    }

    @Override
    public void actualize() {
        //never actualize self wait for parent synchronization
        scheduleActualization();
    }
}
