package ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.actualizers;

import org.jetbrains.annotations.NotNull;

import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductTemplateFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.directory.DirectoryService;
import ru.yandex.chemodan.app.psbilling.core.directory.GroupMembersInfo;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.staff.YandexStaffService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServiceTableSynchronizer;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.inside.passport.PassportUid;

public class StaffGroupServicesActualizer extends AbstractGroupServicesActualizer {

    private final YandexStaffService yandexStaffService;

    StaffGroupServicesActualizer(GroupProductDao groupProductDao, ProductFeatureDao productFeatureDao,
                                 ProductTemplateFeatureDao productTemplateFeatureDao,
                                 DirectoryService directoryService,
                                 GroupServiceTableSynchronizer tablesSynchronizer,
                                 TaskScheduler taskScheduler, GroupDao groupDao,
                                 GroupServiceDao groupServiceDao, FeatureFlags featureFlags, YandexStaffService yandexStaffService, Group group) {
        super(groupProductDao, productFeatureDao, productTemplateFeatureDao, directoryService, tablesSynchronizer,
                taskScheduler, groupDao, groupServiceDao, featureFlags, group);
        this.yandexStaffService = yandexStaffService;
    }

    @Override
    @NotNull GroupMembersInfo getGroupMembersInfo() {
        return new GroupMembersInfo(yandexStaffService.getUidsForSyncing().map(PassportUid::toString).unique());
    }

    @Override
    boolean isBillingEnabled() {
        return true;
    }
}
