package ru.yandex.chemodan.app.psbilling.core.synchronization.groupservicefeature;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.springframework.http.HttpHeaders;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.client.RestTemplate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.features.FeatureCallbackContextDao;
import ru.yandex.chemodan.app.psbilling.core.dao.features.GroupServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.FeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.entities.features.FeatureCallbackContext;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.AbstractFeatureActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.GroupFeatureActualizationTask;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.errorprocessors.ErrorProcessor;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts.GroupTemplateContextFactory;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts.TemplateContext;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.passport.tvm2.Tvm2;

public class GroupFeaturesActualizationService extends AbstractFeatureActualizationService<UUID, GroupFeatureActualizationTask.Parameters> {
    public GroupFeaturesActualizationService(FeatureDao featureDao, ProductFeatureDao productFeatureDao,
                                             RestTemplate externalSystems,
                                             GroupServiceFeatureDao groupServiceFeatureDao,
                                             FeatureCallbackContextDao featureCallbackContextDao,
                                             GroupServiceDao groupServiceDao, Tvm2 tvm2,
                                             TransactionTemplate transactionTemplate,
                                             BazingaTaskManager bazingaTaskManager,
                                             GroupTemplateContextFactory groupTemplateContextFactory,
                                             List<ErrorProcessor> errorProcessors) {
        super(featureDao, productFeatureDao, externalSystems, groupServiceFeatureDao, featureCallbackContextDao,
                groupServiceDao, tvm2, transactionTemplate, bazingaTaskManager, errorProcessors,
                GroupFeatureActualizationTask::new,
                groupTemplateContextFactory);
    }


    protected Map<String, Object> fetchContextFromDb(UUID groupId, UUID featureId) {
        return featureCallbackContextDao
                .findByGroupAndFeature(groupId, featureId)
                .filterMap(FeatureCallbackContext::getData)
                .orElse(Cf.map());
    }

    @Override
    protected FeatureCallbackContext createFeatureCallbackContext(UUID groupId, UUID featureId) {
        return featureCallbackContextDao.insertOrUpdate(
                FeatureCallbackContextDao.InsertData.builder()
                        .groupId(Option.of(groupId)).featureId(featureId).build());
    }

    @Override
    protected void delete(UUID groupId, UUID featureId) {
        featureCallbackContextDao.deleteByGroupAndFeature(groupId, featureId);
    }

    @Override
    protected HttpHeaders buildHeaders(TemplateContext context) {
        return new HttpHeaders();
    }
}
