package ru.yandex.chemodan.app.psbilling.core.synchronization.userservice;

import java.util.UUID;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class UserServiceActualizationTask extends OnetimeTaskSupport<UserServiceActualizationTask.Parameters> {

    private final UserServiceActualizationService userServicesActualizationService;

    public UserServiceActualizationTask(UUID userServiceId)
    {
        super(new Parameters(userServiceId.toString()));
        this.userServicesActualizationService = null;
    }

    public UserServiceActualizationTask(UserServiceActualizationService userServicesActualizationService)
    {
        super(Parameters.class);
        this.userServicesActualizationService = userServicesActualizationService;
    }

    @Override
    protected void execute(UserServiceActualizationTask.Parameters parameters, ExecutionContext context) {
        userServicesActualizationService.actualizeUserService(UUID.fromString(parameters.userServiceId));
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.REGULAR;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardSeconds(30);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1), 3);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return Parameters.Converter.class;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final String userServiceId;

        public Parameters(UUID userServiceId) {
            this.userServiceId = userServiceId.toString();
        }

        public static class Converter implements
                ActiveUniqueIdentifierConverter<Parameters, Parameters>
        {
            @Override
            public Class<Parameters> getActiveUniqueIdentifierClass() {
                return Parameters.class;
            }

            @Override
            public Parameters convert(Parameters parameters) {
                return parameters;
            }
        }
    }

}
