package ru.yandex.chemodan.app.psbilling.core.synchronization.userservice;

import java.util.UUID;

import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.dao.features.UserServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.entities.features.UserFeature;
import ru.yandex.chemodan.app.psbilling.core.entities.features.UserServiceFeature;
import ru.yandex.chemodan.app.psbilling.core.entities.users.UserServiceEntity;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.AbstractTablesSynchronizer;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.UserFeatureActualizationTask;
import ru.yandex.commune.bazinga.BazingaTaskManager;

public class UserServiceTableSynchronizer extends
        AbstractTablesSynchronizer<UserServiceEntity, UserServiceFeature, UserServiceFeatureDao.InsertData>
{
    private final UserServiceFeatureDao userServiceFeatureDao;

    public UserServiceTableSynchronizer(UserServiceFeatureDao childDao, UserServiceDao parentDao,
            TransactionTemplate transactionTemplate, BazingaTaskManager bazingaTaskManager)
    {
        super(childDao, parentDao, transactionTemplate, bazingaTaskManager);
        this.userServiceFeatureDao = childDao;
    }

    @Override
    protected void scheduleChildrenSynchronization(UUID parentId) {
        ListF<UserFeature> notActualChildren = userServiceFeatureDao.findForSynchronization(parentId);
        notActualChildren.map(UserFeatureActualizationTask::new)
                .forEach(bazingaTaskManager::schedule);
    }
}
