package ru.yandex.chemodan.app.psbilling.core.synchronization.userservicefeature;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.springframework.http.HttpHeaders;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.client.RestTemplate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.features.FeatureCallbackContextDao;
import ru.yandex.chemodan.app.psbilling.core.dao.features.UserServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.FeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.entities.features.FeatureCallbackContext;
import ru.yandex.chemodan.app.psbilling.core.entities.products.FeatureEntity;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.AbstractFeatureActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.UserFeatureActualizationTask;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.errorprocessors.ErrorProcessor;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts.TemplateContext;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts.UserTemplateContextFactory;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class UserFeaturesActualizationService extends AbstractFeatureActualizationService<String, UserFeatureActualizationTask.Parameters> {

    private static final Logger featureToggleLogger = LoggerFactory.getLogger("user-feature-toggle");

    public UserFeaturesActualizationService(FeatureDao featureDao, ProductFeatureDao productFeatureDao,
                                            RestTemplate externalSystems, UserServiceFeatureDao userServiceFeatureDao
            , FeatureCallbackContextDao featureCallbackContextDao, UserServiceDao userServiceDao, Tvm2 tvm2,
                                            TransactionTemplate transactionTemplate,
                                            BazingaTaskManager bazingaTaskManager,
                                            List<ErrorProcessor> errorProcessors) {
        super(featureDao, productFeatureDao, externalSystems, userServiceFeatureDao, featureCallbackContextDao,
                userServiceDao, tvm2, transactionTemplate, bazingaTaskManager, errorProcessors,
                UserFeatureActualizationTask::new, new UserTemplateContextFactory());
    }

    protected Map<String, Object> fetchContextFromDb(String uid, UUID featureId) {
        return featureCallbackContextDao
                .findByUidAndFeature(uid, featureId)
                .filterMap(FeatureCallbackContext::getData)
                .orElse(Cf.map());
    }

    @Override
    protected FeatureCallbackContext createFeatureCallbackContext(String uid, UUID featureId) {
        return featureCallbackContextDao.insertOrUpdate(
                FeatureCallbackContextDao.InsertData.builder()
                        .uid(Option.of(uid)).featureId(featureId).build());
    }

    @Override
    protected void delete(String uid, UUID featureId) {
        featureCallbackContextDao.deleteByUidAndFeature(uid, featureId);
    }

    @Override
    protected HttpHeaders buildHeaders(TemplateContext context) {
        HttpHeaders headers = new HttpHeaders();
        if (!StringUtils.isEmpty(context.getUidO().get())) {
            headers.put("X-Uid", Collections.singletonList(context.getUidO().get()));
        }
        return headers;
    }

    @Override
    protected void onToggleFeature(String uid, FeatureEntity feature, boolean activation) {
        featureToggleLogger.info("action={}, feature={}, user={},",
                activation ? "activation" : "deactivation", feature.getCode(), uid);
    }
}
