package ru.yandex.chemodan.app.psbilling.core.tasks;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskExecutor;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPoliciesHolder;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPolicy;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public abstract class BaseTask<T extends BaseTaskParams> extends OnetimeTaskSupport<T> {
    protected static final Logger logger = LoggerFactory.getLogger(BaseTask.class);
    protected TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder;
    protected MapF<String, TaskExecutor<?>> emailTasksExecutors;

    protected BaseTask(T parameters) {
        super(parameters);
    }

    protected BaseTask(TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
                       ListF<TaskExecutor<?>> taskExecutors, Class<T> parametersClass) {
        super(parametersClass);
        this.taskPreExecutionPoliciesHolder = taskPreExecutionPoliciesHolder;
        this.emailTasksExecutors = taskExecutors
                .toMapMappingToKey(TaskExecutor::getKey);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void execute(T taskParams, ExecutionContext context) {
        TaskPreExecutionPolicy<T> policy =
                taskPreExecutionPoliciesHolder.getEmailTaskConfiguration(taskParams);
        if (!policy.canExecute(taskParams)) {
            logger.info("task with params {} is not allowed to execute", taskParams);
            return;
        }
        ((TaskExecutor<T>) emailTasksExecutors.getOrThrow(taskParams.getExecutorKey(),
                "no executor for task " + taskParams))
                .execute(taskParams);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.REGULAR;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(30);
    }
}
