package ru.yandex.chemodan.app.psbilling.core.tasks.execution.promo;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.psbilling.core.mail.MailContext;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoTemplate;
import ru.yandex.chemodan.app.psbilling.core.promos.tasks.ActivatePromoTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskExecutor;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@AllArgsConstructor
public class ActivatePromoTaskTaskExecutor implements TaskExecutor<ActivatePromoTask.Parameters> {
    private static final Logger logger = LoggerFactory.getLogger(ActivatePromoTaskTaskExecutor.class);
    public static final String KEY = ActivatePromoTaskTaskExecutor.class.getName();
    private final PromoService promoService;

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void execute(ActivatePromoTask.Parameters parameters) {
        PromoTemplate promo = promoService.findByCode(parameters.getPromoCode());
        if (promo.isExpired()) {
            logger.warn("promo with key " + promo.getCode() + " is expired");
            return;
        }
        Function<MailContext.MailContextBuilder, MailContext.MailContextBuilder> mailContextModifier =
                parameters.getPaymentErrorContext()
                        .map(context -> (Function<MailContext.MailContextBuilder, MailContext.MailContextBuilder>)
                                (x -> x.userProductId(context.getNotBoughtProductId())))
                        .orElse(Function.identityF());

        promo.activatePromoForUser(parameters.getUserId(), parameters.isActivateIfUsed(), parameters.isSendEmail(),
                mailContextModifier);
    }
}
