package ru.yandex.chemodan.app.psbilling.core.tasks.policies;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.entities.users.OrderStatus;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;
import ru.yandex.inside.passport.PassportUid;

@AllArgsConstructor
public class PoliciesInfoProvider {
    private final UserServiceDao userServiceDao;
    private final OrderDao orderDao;

    public boolean isFreeUser(PassportUid uid) {
        return userServiceDao.find(uid.toString(), Option.empty(), Option.of(Target.ENABLED)).filter(x->x.getProductPriceId().isPresent()).isEmpty()
                && orderDao.findByUid(uid).filter(o -> o.getStatus() == OrderStatus.INIT).isEmpty();
    }
}
