package ru.yandex.chemodan.app.psbilling.core.tasks.policies;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.psbilling.core.tasks.BaseTaskParams;

public class TaskPreExecutionPoliciesHolder {
    private final MapF<String, TaskPreExecutionPolicy<?>> emailTaskProcessStrategies;

    public TaskPreExecutionPoliciesHolder(ListF<TaskPreExecutionPolicy<?>> emailTaskProcessStrategies) {
        this.emailTaskProcessStrategies = emailTaskProcessStrategies
                .toMapMappingToKey(TaskPreExecutionPolicy::getKey);
    }

    @SuppressWarnings("unchecked")
    public <TParams extends BaseTaskParams> TaskPreExecutionPolicy<TParams> getEmailTaskConfiguration(TParams taskParams) {
        return ((TaskPreExecutionPolicy<TParams>) emailTaskProcessStrategies.getOrThrow(taskParams.getPreExecutionPolicy(),
                "no such task process policy: " + taskParams.getPreExecutionPolicy()));
    }
}
