package ru.yandex.chemodan.app.psbilling.core.tasks.policies.mail;

import ru.yandex.chemodan.app.psbilling.core.dao.mail.EmailTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.SentEmailInfoDao;
import ru.yandex.chemodan.app.psbilling.core.mail.configuration.GlobalMailConfiguration;
import ru.yandex.chemodan.app.psbilling.core.mail.tasks.BaseEmailTask;

public class EmailNeverSentBeforeTaskPreExecutionPolicy extends RegularEmailTaskPreExecutionPolicy {
    public static final String KEY = EmailNeverSentBeforeTaskPreExecutionPolicy.class.getName();

    public EmailNeverSentBeforeTaskPreExecutionPolicy(EmailTemplateDao emailTemplateDao,
                                                      GlobalMailConfiguration globalMailConfiguration,
                                                      SentEmailInfoDao sentEmailInfoDao) {
        super(emailTemplateDao, globalMailConfiguration, sentEmailInfoDao);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public boolean canSchedule(BaseEmailTask.Parameters parameters) {
        return super.canSchedule(parameters)
                && !sentEmailInfoDao.find(parameters.getContext().getDistinctRecipient(), parameters.getEmailKey())
                        .isPresent();
    }

    @Override
    public boolean canExecute(BaseEmailTask.Parameters parameters) {
        return super.canExecute(parameters)
                && !sentEmailInfoDao.find(parameters.getContext().getDistinctRecipient(), parameters.getEmailKey())
                        .isPresent();
    }
}
