package ru.yandex.chemodan.app.psbilling.core.tasks.policies.mail;

import ru.yandex.chemodan.app.psbilling.core.dao.mail.EmailTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.SentEmailInfoDao;
import ru.yandex.chemodan.app.psbilling.core.mail.configuration.GlobalMailConfiguration;
import ru.yandex.chemodan.app.psbilling.core.mail.tasks.BaseEmailTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.PoliciesInfoProvider;

public class OnlyFreeUsersEmailTaskPreExecutionPolicy extends RegularEmailTaskPreExecutionPolicy {
    public static final String KEY = OnlyFreeUsersEmailTaskPreExecutionPolicy.class.getName();

    private final PoliciesInfoProvider policiesInfoProvider;

    public OnlyFreeUsersEmailTaskPreExecutionPolicy(EmailTemplateDao emailTemplateDao,
                                                    GlobalMailConfiguration globalMailConfiguration,
                                                    PoliciesInfoProvider policiesInfoProvider,
                                                    SentEmailInfoDao sentEmailInfoDao) {
        super(emailTemplateDao, globalMailConfiguration, sentEmailInfoDao);
        this.policiesInfoProvider = policiesInfoProvider;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public boolean canSchedule(BaseEmailTask.Parameters parameters) {
        return super.canSchedule(parameters)
                && policiesInfoProvider.isFreeUser(parameters.getUser());
    }

    @Override
    public boolean canExecute(BaseEmailTask.Parameters parameters) {
        return super.canExecute(parameters)
                && policiesInfoProvider.isFreeUser(parameters.getUser());
    }
}
