package ru.yandex.chemodan.app.psbilling.core.tasks.policies.mail;

import lombok.AllArgsConstructor;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.EmailTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.SentEmailInfoDao;
import ru.yandex.chemodan.app.psbilling.core.entities.mail.SentEmailInfoEntity;
import ru.yandex.chemodan.app.psbilling.core.mail.configuration.GlobalMailConfiguration;
import ru.yandex.chemodan.app.psbilling.core.mail.tasks.BaseEmailTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPolicy;

@AllArgsConstructor
public class RegularEmailTaskPreExecutionPolicy implements TaskPreExecutionPolicy<BaseEmailTask.Parameters> {
    public static final String KEY = RegularEmailTaskPreExecutionPolicy.class.getName();

    protected final EmailTemplateDao emailTemplateDao;
    protected final GlobalMailConfiguration globalMailConfiguration;
    protected final SentEmailInfoDao sentEmailInfoDao;

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public boolean canSchedule(BaseEmailTask.Parameters parameters) {
        return true;
    }

    @Override
    public boolean canExecute(BaseEmailTask.Parameters parameters) {
        return globalMailConfiguration.isTaskEnabled(parameters)
                && isCoolDownPassed(parameters);
    }

    private boolean isCoolDownPassed(BaseEmailTask.Parameters parameters) {
        Option<Duration> cooldownO = parameters.getCooldown();
        if (!cooldownO.isPresent()) {
            return true;
        }

        Option<Instant> lastEmailDate =
                sentEmailInfoDao.find(parameters.getContext().getDistinctRecipient(), parameters.getEmailKey())
                        .map(SentEmailInfoEntity::getSentDate);

        return !lastEmailDate.isPresent()
                || lastEmailDate.get()
                .plus(cooldownO.get())
                .isBeforeNow();
    }
}
