package ru.yandex.chemodan.app.psbilling.core.tasks.policies.promo;

import java.util.Objects;
import java.util.UUID;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.psbilling.core.products.ProductLineService;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoTemplate;
import ru.yandex.chemodan.app.psbilling.core.promos.tasks.ActivatePromoTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.PoliciesInfoProvider;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPolicy;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@RequiredArgsConstructor
public class PromoActivationPreExecutionPolicy implements TaskPreExecutionPolicy<ActivatePromoTask.Parameters> {
    private static final Logger logger = LoggerFactory.getLogger(PromoActivationPreExecutionPolicy.class);
    public static final String KEY = PromoActivationPreExecutionPolicy.class.getName();

    private final PromoService promoService;
    private final PoliciesInfoProvider policiesInfoProvider;
    private final ProductLineService productLineService;


    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public boolean canSchedule(ActivatePromoTask.Parameters parameters) {
        return shouldActivate(parameters.getUserId(), parameters.getPromoCode(), parameters.isActivateIfUsed());
    }

    @Override
    public boolean canExecute(ActivatePromoTask.Parameters parameters) {
        return shouldActivate(parameters.getUserId(), parameters.getPromoCode(), parameters.isActivateIfUsed());
    }

    public boolean shouldActivate(PassportUid uid, String promoCode, boolean activateIfUsed) {
        return policiesInfoProvider.isFreeUser(uid) && canActivatePromo(uid, promoCode, activateIfUsed);
    }

    private boolean canActivatePromo(PassportUid uid, String promoCode, boolean activateIfUsed) {
        PromoTemplate promoToActivate = promoService.findByCode(promoCode);

        ListF<PromoTemplate> allPromo = promoService.findAllWithUidUsageCached(Option.of(uid))
                .filter(p -> !Objects.equals(p.getCode(), promoToActivate.getCode()));
        if (allPromo.size() > 0) {
            SetF<UUID> promoProductSets = productLineService.getProductSetIds(promoToActivate.getProductLineIds());

            for (PromoTemplate promo : allPromo) {
                SetF<UUID> productSetsToTest = productLineService.getProductSetIds(promo.getProductLineIds());

                if (promo.canBeUsedForUid(uid) && promoProductSets.exists(productSetsToTest::containsTs)) {
                    logger.info("cannot activate {} promo for user {} cause he has an another promo {} ready for usage",
                            promoToActivate, uid, promo.getCode());
                    return false;
                }
            }
        }

        return promoToActivate.canActivateForUid(uid, activateIfUsed);
    }
}
