package ru.yandex.chemodan.app.psbilling.core.texts;

import java.util.UUID;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.texts.TankerTranslationEntity;
import ru.yandex.misc.lang.StringUtils;

public class TankerTranslation {
    public static final String RUSSIAN_LANGUAGE = "ru";
    public static final String DEFAULT_LANGUAGE = RUSSIAN_LANGUAGE;

    private final UUID keyEntityId;
    private final ListF<TankerTranslationEntity> translations;

    public TankerTranslation(UUID keyEntityId, ListF<TankerTranslationEntity> translations) {
        this.keyEntityId = keyEntityId;
        this.translations = translations;
    }

    public UUID getKeyId() {
        return keyEntityId;
    }

    public MapF<String, String> getAllLanguageTexts() {
        return translations.toMap(TankerTranslationEntity::getLocale, TankerTranslationEntity::getTranslationText);
    }

    public Option<String> findLanguageTranslation(String language) {
        Option<String> userLangText = translations
                .filter(t -> StringUtils.equalsIgnoreCase(t.getLocale(), language)).firstO()
                .map(TankerTranslationEntity::getTranslationText);
        if (userLangText.isPresent() && StringUtils.isNotBlank(userLangText.get())) {
            return userLangText;
        }
        return Option.empty();
    }


    public Option<String> findTranslation(String language, String defaultLanguage) {
        Option<String> userLangText = translations
                .filter(t -> StringUtils.equalsIgnoreCase(t.getLocale(), language)).firstO()
                .map(TankerTranslationEntity::getTranslationText);
        if (userLangText.isPresent() && StringUtils.isNotBlank(userLangText.get())) {
            return userLangText;
        }

        //default language translation
        return translations
                .filter(t -> StringUtils.equalsIgnoreCase(t.getLocale(), defaultLanguage)).firstO()
                .map(TankerTranslationEntity::getTranslationText);
    }

    public Option<String> findByLangOrDefault(String language) {
        return findTranslation(language, DEFAULT_LANGUAGE);
    }
}
