package ru.yandex.chemodan.app.psbilling.core.users;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.users.tasks.DeleteUserTask;
import ru.yandex.chemodan.app.psbilling.core.util.BatchFetchingUtils;
import ru.yandex.chemodan.app.psbilling.core.yt.YtSelectService;
import ru.yandex.chemodan.util.date.DateTimeUtils;

@AllArgsConstructor
public class UserPassportSyncService {
    private static final Integer UIDS_FETCH_BATCH_SIZE = 1000;

    private final YtSelectService ytSelectService;
    private final UserServiceDao userServiceDao;
    private final TaskScheduler taskScheduler;

    public void syncDeletedInPassportUsers() {
        BatchFetchingUtils.collectBatchedEntities(
                userServiceDao::findActiveUids,
                ytSelectService.getDeletedInPassportUids(DateTimeUtils.yesterdayLd()),
                UIDS_FETCH_BATCH_SIZE
        ).map(DeleteUserTask::new).forEach(taskScheduler::schedule);
    }
}
