package ru.yandex.chemodan.app.psbilling.core.users.tasks;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.products.BillingType;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.chemodan.app.psbilling.core.users.UserService;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class DeleteUserTask extends OnetimeTaskSupport<DeleteUserTask.Parameters> {
    private UserServiceManager userServiceManager;

    public DeleteUserTask(PassportUid uid) {
        super(new DeleteUserTask.Parameters(uid.getUid()));
    }

    public DeleteUserTask(UserServiceManager userServiceManager) {
        super(DeleteUserTask.Parameters.class);
        this.userServiceManager = userServiceManager;
    }

    @Override
    protected void execute(DeleteUserTask.Parameters parameters, ExecutionContext context) {
        ListF<UserService> userServices = userServiceManager.findEnabled(String.valueOf(parameters.uid), Option.empty());

        for (UserService userService: userServices) {
            if (userService.getUserProduct().getBillingType() == BillingType.TRUST) {
                userServiceManager.stopAutoProlong(PassportUid.cons(parameters.uid), userService.getId(), Option.empty());
            }
            userServiceManager.disableService(userService.getId());
        }
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1), 5);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.REGULAR;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return DeleteUserTask.Parameters.Converter.class;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final Long uid;

        public static class Converter implements
                ActiveUniqueIdentifierConverter<DeleteUserTask.Parameters,
                        DeleteUserTask.Parameters> {
            @Override
            public Class<DeleteUserTask.Parameters> getActiveUniqueIdentifierClass() {
                return DeleteUserTask.Parameters.class;
            }

            @Override
            public DeleteUserTask.Parameters convert(DeleteUserTask.Parameters parameters) {
                return parameters;
            }
        }
    }
}
