package ru.yandex.chemodan.app.psbilling.core.util;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public class ActionResult {
    boolean isSuccess;
    String message;
    String error;
    String errorCode;

    public static ActionResult success() {
        return new ActionResult(true, "", "", "");
    }

    public static ActionResult success(String message) {
        return new ActionResult(true, message, "", "");
    }

    public static ActionResult fail(String error) {
        return fail(error, error);
    }

    public static ActionResult fail(String error, String errorCode) {
        return fail(error, error, errorCode);
    }

    public static ActionResult fail(String message, String error, String errorCode) {
        return new ActionResult(false, message, error, errorCode);
    }
}
