package ru.yandex.chemodan.app.psbilling.core.util;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

public class CurrencyUtils {
    private static final MapF<String, String> normalizeCurrencyMap = Cf.map("RUR", "RUB");

    public static String normalize(String currencyCode) {
        return normalizeCurrencyMap.getOrElse(currencyCode, currencyCode);
    }

    public static boolean normalizedEquals(String currencyCode1, String currencyCode2) {
        return normalize(currencyCode1).equals(normalize(currencyCode2));
    }
}
