package ru.yandex.chemodan.app.psbilling.core.util;

import java.util.Map;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.SneakyThrows;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.lang.StringUtils;

public class JsonHelper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @SneakyThrows
    public static Map<String, Object> parseJson(String data) throws JsonParseException {
        return OBJECT_MAPPER.readValue(data, new TypeReference<Map<String, Object>>() {
        });
    }

    @SneakyThrows
    public static Map<String, Object> parseJsonQuiet(String data) {
        return OBJECT_MAPPER.readValue(data, new TypeReference<Map<String, Object>>() {
        });
    }

    @SneakyThrows
    public static <T> T parseJsonQuiet(String data, Class<T> clazz) {
        return OBJECT_MAPPER.readValue(data, clazz);
    }

    @SneakyThrows
    public static String asString(Map<String, Object> json) {
        return OBJECT_MAPPER.writeValueAsString(json);
    }

    public static Map<String, Object> getJsonToMap(String response) {
        Map<String, Object> responseAsMap;
        if (StringUtils.isEmpty(response)) {
            responseAsMap = Cf.map();
        } else {
            try {
                responseAsMap = parseJson(response);
            } catch (JsonParseException e) {
                responseAsMap = Cf.map();
            }
        }
        return responseAsMap;
    }
}
