package ru.yandex.chemodan.app.psbilling.core.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

import ru.yandex.bolts.collection.impl.TraversableF;

public class MathUtils {
    public static BigDecimal sum(TraversableF<BigDecimal> collection) {
        return collection.reduceLeftO(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public static boolean areNear(BigDecimal one, BigDecimal another, int scale) {
        BigDecimal oneScaled = one.setScale(scale, RoundingMode.HALF_UP);
        BigDecimal anotherScaled = another.setScale(scale, RoundingMode.HALF_UP);
        return oneScaled.compareTo(anotherScaled) == 0;
    }
}
