package ru.yandex.chemodan.app.psbilling.core.util;

import lombok.Getter;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

@Getter
public class RequestTemplate {
    private final HttpMethod httpMethod;
    private final String urlTemplate;
    private final Option<String> bodyTemplate;
    private final Option<MediaType> contentType;

    public RequestTemplate(HttpMethod httpMethod, String urlTemplate, Option<String> bodyTemplate,
            Option<MediaType> contentType)
    {
        this.httpMethod = httpMethod;
        this.urlTemplate = urlTemplate;
        this.bodyTemplate = bodyTemplate;
        this.contentType = contentType;
        //disable some possibilities of SpEL
        Assert.isFalse(urlTemplate.contains("T("), "template must not contain 'T('");
        Assert.isFalse(urlTemplate.contains("new "), "template must not contain 'new '");
        if (bodyTemplate.isPresent()) {
            Assert.isFalse(bodyTemplate.get().contains("T("), "template must not contain 'T('");
            Assert.isFalse(bodyTemplate.get().contains("new "), "template must not contain 'new '");
        }
    }
}
