package ru.yandex.chemodan.app.psbilling.core.util.impl;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.texts.TankerTranslation;
import ru.yandex.chemodan.app.psbilling.core.util.LanguageService;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDbFields;
import ru.yandex.misc.net.LocalhostUtils;


@RequiredArgsConstructor
public class BlackboxLanguageService implements LanguageService {

    private final Blackbox2 blackbox2;

    @Override
    public String findUserLanguage(Option<PassportUid> uidO) {
        return uidO
                .flatMapO(this::fromBlackBox)
                .orElse(TankerTranslation.DEFAULT_LANGUAGE);
    }

    private Option<String> fromBlackBox(PassportUid u) {
        return blackbox2.query()
                .userInfo(LocalhostUtils.localAddress(), u, Cf.list(BlackboxDbFields.LANG), Cf.list())
                .getDbFields().getO(BlackboxDbFields.LANG);
    }

}
