package ru.yandex.chemodan.app.psbilling.core.yt;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import lombok.AllArgsConstructor;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.inside.passport.PassportUid;

@AllArgsConstructor
public class YtSelectService {
    private final MapF<YtCluster, String> yqlUrls;
    private final String yqlToken;

    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy-MM-dd");

    public ListF<PassportUid> getDeletedInPassportUids(LocalDate date) {
        return select(
                YtCluster.HAHN,
                String.format(
                        "select uid from `logs/passport-log/1d/%s` where mode = 'account_delete' and action = 'deleted'",
                        date.toString(formatter)
                ),
                this::parsePassportUid
        );
    }

    private PassportUid parsePassportUid(ResultSet resultSet) {
        try {
            return PassportUid.cons(Long.parseLong(resultSet.getString("uid")));
        } catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private <T> ListF<T> select(YtCluster cluster, String sql, Function<ResultSet, T> f) {
        try {
            // Что бы заработал YQL драйвер
            Class.forName("ru.yandex.yql.YqlDriver");

            Connection connection = DriverManager.getConnection(yqlUrls.getOrThrow(cluster), "unused", yqlToken);
            PreparedStatement statement = connection.prepareStatement(sql);

            ListF<T> result = Cf.arrayList();
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                result.add(f.apply(resultSet));
            }

            return result;
        } catch (SQLException | ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}
