package ru.yandex.chemodan.directory.client;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.misc.lang.DefaultObject;


@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
@NoArgsConstructor
public class DirectoryOrganizationFeaturesResponse extends DefaultObject {
    @JsonProperty("edu_360")
    private Features edu360;
    @JsonProperty("disable_psbilling_processing")
    private Features disablePsbillingProcessing;

    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Features extends DefaultObject {
        private boolean enabled;
    }

    public DirectoryOrganizationFeaturesResponse(Boolean eduEnabled, Boolean disablePsbillingProcessingEnabled) {
        this.edu360 = new Features(eduEnabled);
        this.disablePsbillingProcessing = new Features(disablePsbillingProcessingEnabled);
    }

    public boolean isEdu360Active() {
        return edu360 != null && edu360.isEnabled();
    }

    public boolean isDisablePsbillingProcessingActive() {
        return disablePsbillingProcessing != null && disablePsbillingProcessing.isEnabled();
    }
}
